local assets=
{
	Asset("IMAGE", "images/inventoryimages/ted.tex"),
    Asset("ATLAS", "images/inventoryimages/ted.xml"),
    Asset("ANIM", "anim/ted.zip"),
	Asset("ANIM", "anim/ted_spear.zip"),
}
local function onfinished(inst)
    inst:Remove()
end




local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_ted", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("spear")
    anim:SetBuild("ted")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(15)
    
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_SMALL
    -------



    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname =     "images/inventoryimages/ted.xml"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/ted", fn, assets) 
